<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;

class SendFile extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'app:send-file {filepath}';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Command description';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        $filePath = $this->argument('filepath');
        $path = base_path($filePath);
        $fileName = basename($path);

        $file = fopen($path, "rb");
        $bin = fread($file, filesize($path));
        $hex = bin2hex($bin);
        $chunks = str_split($hex, 1024 * 300);
        $salt = 'some_salt';
        echo 'File: ' . $fileName . PHP_EOL;
        echo 'Chunks: ' . sizeof($chunks) . PHP_EOL;
        foreach ($chunks as $index => $chunk) {
            echo 'Sending: ' . ($index + 1 . ' of ' . sizeof($chunks)) . PHP_EOL;
            $isLast = intval($index == count($chunks) - 1);
            $hash = md5($filePath . $chunk . $isLast . $salt);
            $opts = [
                'http' => [
                    'method' => "POST",
                    'header' => "Content-Type: application/x-www-form-urlencoded",
                    'content' => http_build_query([
                        'hash'          => $hash,
                        'file_path'     => $filePath,
                        'chunk'         => $chunk,
                        'last'          => $isLast,
                    ])
                ]
            ];
            $context = stream_context_create($opts);
            $result = file_get_contents('https://host/dsreceiver.php?part=' . $index, false, $context);
            if (!$result) {
                echo 'Fail';
                exit;
            }
            sleep(1);
        }
        echo 'Sent' . PHP_EOL;
    }
}
