<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;

class GetFile extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'app:get-file {filepath} {filename}';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Command description';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        $salt = 'some_salt';
        $name = $this->argument('filename');
        $path = $this->argument('filepath');
        $opts = [
            'http' => [
                'method' => "POST",
                'header' => "Content-Type: application/x-www-form-urlencoded",
                'content' => http_build_query([
                    'path' => $path,
                    'hash' => md5($path . $salt),
                ])
            ]
        ];
        $context = stream_context_create($opts);
        $result = file_get_contents('https://host/reader.php', false, $context);
        if (!empty($result)) {
            file_put_contents($name, $result);
        } else {
            echo 'Failed to read from the file';
        }
    }
}
